// ===== Conferma riga per "Liquidazione delle spese" (allineato al nuovo layout) =====

// numeri con , o . e max 2 decimali (es: 123,45 o 123.45 o 123)
const NUM_RE_IMPORTI = /^\d+(?:[.,]\d{1,2})?$/;

// Helpers base
function setInvalid($el, $errNode, msg){
  $el.addClass("is-invalid");
  if ($errNode && $errNode.length){
    $errNode.addClass("invalid-feedback").text(msg).show();
  }
}
function clearInvalid($el, $errNode){
  $el.removeClass("is-invalid");
  if ($errNode && $errNode.length){
    $errNode.removeClass("invalid-feedback").text("").hide();
  }
}

// Validazioni specifiche
function validaSelectObbligatoria($sel, $errNode, msg){
  if (($sel.val() || "") === ""){
    setInvalid($sel, $errNode, msg);
    return false;
  }
  clearInvalid($sel, $errNode);
  return true;
}
function validaTestoObbligatorio($inp, $errNode, msg){
  if (($inp.val() || "").trim() === ""){
    setInvalid($inp, $errNode, msg);
    return false;
  }
  clearInvalid($inp, $errNode);
  return true;
}
function validaImporto($inp){
  const raw = ($inp.val() || "").trim();
  const $errInline = $inp.siblings(".invalid-feedback");       // la <div class="invalid-feedback"> sotto l'input
  // Se vuoi obbligatorio, cambia qui: if (raw==='') -> errore
  if (raw === ""){
    clearInvalid($inp, $errInline); // vuoto: lo consideriamo valido (la live validation e il submit finale lo gestiranno)
    return true;
  }
  const ok = NUM_RE_IMPORTI.test(raw);
  if (!ok){
    setInvalid($inp, $errInline, "Inserisci un valore numerico valido");
    return false;
  }
  clearInvalid($inp, $errInline);
  return true;
}
function validaPdf($file, $errNode, msg){
  const f = $file[0]?.files?.[0] || null;
  if (!f){
    // Se vuoi renderlo obbligatorio, metti: setInvalid($file, $errNode, msg); return false;
    clearInvalid($file, $errNode);
    return true;
  }
  const ok = f.type === "application/pdf" || /\.pdf$/i.test(f.name);
  if (!ok){
    setInvalid($file, $errNode, msg || "Carica un PDF valido");
    return false;
  }
  clearInvalid($file, $errNode);
  return true;
}

// Conta errori nella riga (input/select con .is-invalid)
function contaErroriRiga($tr){
  return $tr.find(".is-invalid").length;
}

// Click sulla spunta verde -> valida la riga
$(document).on("click", ".conferma-riga-investimenti", function(){
  const $tr = $(this).closest("tr");
  const idRiga = $tr.attr("id") || "";

  // Selettori per NOME (robusti anche se cambiano le colonne)
  const $categoria   = $tr.find('select[name="categoria_interventi"]');
  const $nFattura    = $tr.find('input[name="n_fattura"]');
  const $emittente   = $tr.find('input[name="emittente_fattura"]');
  const $descrizione = $tr.find('input[name="descrizione_fattura"]');
  const $imponibile  = $tr.find('input[name="importo_imponibile"]');
  const $ivato       = $tr.find('input[name="importo_ivato"]');
  const $contributo  = $tr.find('input[name="contributo_richiesto"]');
  const $pdf         = $tr.find('input[name="copia_fattura"]');

  // Nodi errore classici (per select/text). Per i numerici usiamo .invalid-feedback sotto l'input
  const $errCat  = $tr.find('.error_categoria_interventi');
  const $errNF   = $tr.find('.error_n_fattura');
  const $errEm   = $tr.find('.error_emittente_fattura');
  const $errDesc = $tr.find('.error_descrizione_fattura');
  const $errPdf  = $tr.find('.error_copia_fattura');

  // Validazioni obbligatorie
  const okCat  = validaSelectObbligatoria($categoria,  $errCat,  "Seleziona la categoria di intervento.");
  // Se vuoi rendere obbligatorio il numero fattura, sblocca la riga seguente:
  const okNF   = validaTestoObbligatorio($nFattura,    $errNF,   "Inserisci il numero della fattura.");
  const okEm   = validaTestoObbligatorio($emittente,   $errEm,   "Inserisci l'emittente della fattura.");
  const okDesc = validaTestoObbligatorio($descrizione, $errDesc, "Inserisci una descrizione della fattura.");

  // Importi (accetta 12,34 e 12.34)
  const okImp = validaImporto($imponibile);
  const okIva = validaImporto($ivato);
  const okCtr = validaImporto($contributo);

  // PDF (qui è opzionale; se lo vuoi obbligatorio: passa msg e fai fallire su f mancante)
  const okPdf = validaPdf($pdf, $errPdf, "Carica la copia della fattura in PDF.");

  // Esito complessivo
  const errori = contaErroriRiga($tr);
  if (idRiga) $tr.attr("data-errori-riga", errori);

  // Se tutto ok, aggiorno i totali (usa la tua ricalcola() vanilla)
  if (errori === 0 && typeof ricalcola === "function") {
    ricalcola();
  }
});